/*
 *  $Id: libnet_socket.c,v 1.1.1.1 2000/05/25 00:28:49 route Exp $
 *
 *  libnet
 *  libnet_socket.c - raw sockets routines
 *
 *  Copyright (c) 1998 - 2001 Mike D. Schiffman <mike@infonexus.com>
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#if (HAVE_CONFIG_H)
#include "../include/config.h"
#endif
#include "../include/libnet.h"

#if (WIN32 || __linux__)
 /* socket is emulated via a permanent link layer openend on default interface */
 struct libnet_link_int *libnet_socket=NULL;
#endif

int
libnet_open_raw_sock(prot)
{
#if (WIN32 || __linux__)
 /* will emulate prot=IPPROTO_RAW systematically */
 /* the socket is a virtual one, always connected to the default interface */
 char	err_buf[LIBNET_ERRBUF_SIZE];
 struct sockaddr_in sin;
 #if (WIN32)
 char *device=(char *)calloc(1,sizeof(char)*512);
 #else
 char *device=NULL;
 #endif

 if (!libnet_socket)
  {
   if (libnet_select_device(&sin,&device,&err_buf[0]) == -1)
   {
	printf(" failed to select device \n");
	   return (-1);
   }
   if ((libnet_socket = libnet_open_link_interface(device,err_buf)) == NULL) return (-1);
  }

 free(device);
 return (1);
#else
    int fd;
    int one = 1;
#if (__svr4__)
    void *oneptr = &one;
#else
    int *oneptr = &one;
#endif  /* __svr4__ */

    fd = socket(AF_INET, SOCK_RAW, prot);
    if (fd == -1)
    {
#if (__DEBUG)
        libnet_error(LIBNET_ERR_CRITICAL,
            "libnet_open_raw_sock: SOCK_RAW allocation failed: %s\n",
            strerror(errno));
#endif
        return (-1);
    }
    if (setsockopt(fd, IPPROTO_IP, IP_HDRINCL, oneptr, sizeof(one)) == -1)
    {
#if (__DEBUG)
        libnet_error(LIBNET_ERR_CRITICAL,
                "libnet_open_raw_sock: set IP_HDRINCL failed: %s\n",
                strerror(errno));
#endif
        return (-1);
    }
    return (fd);
#endif /* WIN32 || __linux__ */
}


int
libnet_close_raw_sock(int fd)
{
#if (WIN32 || __linux__)
 libnet_close_link_interface(libnet_socket);
 libnet_socket=NULL;
 return 1;
#else
 return (close(fd));
#endif
}
/* EOF */
