#ifndef INCLUDED_IPSPACE_H
#define INCLUDED_IPSPACE_H

#include "types.h"

#define IPSPACE_RANDOM_DEV		"/dev/random"

#define IPSPACE_NUMROUNDS		8
#define IPSPACE_DIRECTIVE_DELIM	":/"

typedef struct {
	u32	offset_start, offset_end,
		base_ip,
		rmask, hmask,
		key, subkeys[IPSPACE_NUMROUNDS],
		numrbits;
	bool key_specified, repeat;
} ipspace;

bool ipspace_init(ipspace *, s8 *);
bool ipspace_generate(ipspace * const, const int fd);
void ipspace_find_offset(ipspace * const, const u32, u32 *);
void ipspace_print_split(ipspace * const, const u32);

#endif	/* INCLUDED_IPSPACE_H */
