#include <stdio.h>
#include <string.h>

#include "types.h"

char *
arg_get(unsigned int argc, char **argv, char *wantedkey)
{
	unsigned int argi, wantedkeylen, keylen;
	char *p;

	wantedkeylen = strlen(wantedkey);

	for (argi=1; argi<argc; argi++) {									/* argi = 1 because we are skipping argv[0] */
		p = strchr(argv[argi], '=');									/* put address of '=' in p */
		if (p == NULL) continue;										/* continue if there was no '=' in the string */
		keylen = p - argv[argi];										/* find length of current key */
		if (keylen != wantedkeylen) continue;							/* continue if the current key is not equal in length to the wanted key */
		if (strncmp(argv[argi], wantedkey, wantedkeylen)) continue;		/* continue if the current key does not equal the wanted key */
		return p + 1;													/* return the address of the char after the '=' */
	}
	return NULL;
}
